#include "driver.h"
#include "gpsoundbuf.h"
#include "sound_96k.h"

/* audio related stuff */
#define NUMVOICES 8
/*
#define LO_RATE 11025
#define HI_RATE 22050
*/
#define LO_RATE 11160
#define HI_RATE 22321
#define MX_RATE 39062
#define MAX_SAMPLE_NUMBER 1600
#define SOUND_USESAMPLE_PATCH 0

/* gpsoundbuf structure */
GPSOUNDBUF sb;


struct lpWaves {
#if SOUND_USESAMPLE_PATCH
        signed char *lpData;
#else
	signed char lpData[MAX_SAMPLE_NUMBER] __attribute__ ((__aligned__ (32)));
#endif
	int len; /* length of sound buffer */
	int freq; /* frequency of sound buffer */
	int active; /* 1 active, 0 inactive */
	int volume; /* volume 0 - 64 */
	int loop; /* loop 1 yes, 0 no */
	int step; /* step of the sample */
#if SOUND_USESAMPLE_PATCH
};
#else
} __attribute__ ((__aligned__ (32)));
#endif

struct lpWaves lpWave[NUMVOICES];
int sample_rate = LO_RATE;
int min_sample_rate;
int max_sample_rate;
int sound_enable = 0;
int soundcard;
int chn_max=0; /* Max Number of channels */
int mixer_count = 0;
int mixer_count_ok = 0;
int callback_count = 0;
int callback_count_ok = 0;

#include "sound.h"

static void gp32_sound_mixer ( void * userdata, unsigned char * stream, int len )
{
	int channel;
	int i;
	int t;
	struct lpWaves *wave = lpWave;
	struct lpWaves *waves;
	

	/* Sound Enable ? */	
	if (!sound_enable) { 
		/* Buffer Set to Zero */
		for (i=0;i<len;i++) *stream++=0x80;
		return;
	}
	
	/* Precalculations */
	t=0;
	waves=wave;
	channel=NUMVOICES;
	do {
		/* Channel active ? */
		if (waves->active) {

			/* Calculate step of the sample */
			if((waves->freq)>min_sample_rate && (waves->freq)<max_sample_rate) {
				if(mixer_count==mixer_count_ok && soundcard==1) return;
				waves->step=1; /* pos++ */
			} else {
				waves->step=0;
			}
			
			t++;
		}
		waves++;
	} while (--channel);

	if (!t) {
		/* Buffer Set to Zero */
		for (i=0;i<len;i++) *stream++=0x80;
		return;
	}
	if (t>chn_max)
		chn_max=t;

	/* For each of the channels */
	i=0;
	waves=wave;
	do {
		/* Channel active ? */
		if (waves->active) {
			i++;
			
			if (chn_max==1 && (waves->volume)>32) { /* Only one channel max. */
				if (waves->step)
					gp32_sound_mixer_channel_single_step(stream,len,waves);
				else if (waves->freq==96000 && waves->len==MAX_SAMPLE_NUMBER)
					gp32_sound_mixer_channel_single_nostep_96k(stream,len,waves);
				else
					gp32_sound_mixer_channel_single_nostep(stream,len,waves);
			} 
			else if (t==1) { /* Only one channel */
				if (waves->step)
					gp32_sound_mixer_channel_step (stream,len,waves,3,chn_max);
				else
					gp32_sound_mixer_channel_nostep (stream,len,waves,3,chn_max);
			}
			else if (i==1) { /* First channel */
				if (waves->step)
					gp32_sound_mixer_channel_step (stream,len,waves,1,chn_max);
				else
					gp32_sound_mixer_channel_nostep (stream,len,waves,1,chn_max);
			}
			else if (i==t) { /* Last channel */
				if (waves->step)
					gp32_sound_mixer_channel_step (stream,len,waves,2,chn_max);
				else
					gp32_sound_mixer_channel_nostep (stream,len,waves,2,chn_max);
			}
			else { /* Normal channel */
				if (waves->step)
					gp32_sound_mixer_channel_step (stream,len,waves,0,chn_max);
				else
					gp32_sound_mixer_channel_nostep (stream,len,waves,0,chn_max);
			}

			/* If no loop -> not active */
			if (!(waves->loop))
				waves->active=0;
		}
			
		/* Next channel */
		waves++;
		
	} while (i<t);
	
	/* Sound Updated ! */
	mixer_count_ok = mixer_count;
	callback_count_ok = callback_count;
}

#if 0
int msdos_init_seal (void)
{
        sb.freq = PCM_M22;
        sb.format = PCM_8BIT;
        sb.samples = 367 /* SAMPLE_RATE/60 */;
        sb.userdata = NULL;
        sb.callback = gp32_sound_mixer;
        sb.pollfreq = 120; /* 100 */
        GpPcmInit(PCM_M22,PCM_8BIT);
        return 0;
}
#endif

int msdos_init_seal (void)
{
	/* enable 22050hz only if "Accurate (22050)" selected */
	if (soundcard == 5)
	{
		sample_rate = MX_RATE;
		sb.freq = PCM_M44;
	}
	else if (soundcard == 4)
	{
		sample_rate = HI_RATE;
		sb.freq = PCM_M22;
	}
	else
	{
		sample_rate = LO_RATE;
		sb.freq = PCM_M11;
	}

	/* Determine min/max sample_rate rate match required for mixer */
	/* Accurate modes will do more accurate mixing */
	if (soundcard >= 3)
	{
		min_sample_rate = (int)(sample_rate * 0.985);
		max_sample_rate = (int)(sample_rate * 1.015);
	}
	else
	{
		min_sample_rate = (int)(sample_rate * 0.85);
		max_sample_rate = (int)(sample_rate * 1.15);
	}

	sb.format = PCM_8BIT;
	sb.samples = (unsigned int)(sample_rate / Machine->drv->frames_per_second);
	sb.userdata = NULL;
	sb.callback = gp32_sound_mixer;
	sb.pollfreq = 150; /* 100 */
	GpPcmInit(sb.freq, sb.format);
	return 0;
}

int msdos_init_sound(void)
{
	int i;
	sound_enable=0;

	/* Initialize Sound Buffer Structure */
	for (i = 0; i < NUMVOICES; i++)
	{
		lpWave[i].len = 0;
		lpWave[i].freq = 0;
		lpWave[i].active = 0;
		lpWave[i].volume = 0;
		lpWave[i].loop = 0;
	}
	mixer_count = 0;
	mixer_count_ok = -1;
	callback_count = 0;
	callback_count_ok = 0;
	chn_max=0;

	if (soundcard == 0)     /* Sound Deactivated and not emulated */
	{
		gp32_text_log("GP32 Sound Not Emulated...");
		/* update the Machine structure to show that sound is disabled */
		Machine->sample_rate = 0;
		return 0;
	}

	if (soundcard == 2) /* Sound Deactivated but emulated */
	{
		gp32_text_log("GP32 Emulated But No Sound...");
		soundcard = 0;
		return 0;
	}

	gp32_text_log("GP32 Sound Init...");
	sound_enable = 1;

	/* update the Machine structure to reflect the actual sample rate */
	Machine->sample_rate = sample_rate;
	GpSoundBufStart(&sb);

	return 0;
}

void msdos_shutdown_sound(void)
{
	int i;

	/* stop and release voices */
	sound_enable = 0;
	if (soundcard)
		GpSoundBufStop();
	
	for (i = 0; i < NUMVOICES; i++)
	{
		lpWave[i].len = 0;
		lpWave[i].freq = 0;
		lpWave[i].active = 0;
		lpWave[i].volume = 0;
		lpWave[i].loop = 0;
	}
	mixer_count = 0;
	mixer_count_ok = -1;
	chn_max=0;
}


void osd_update_audio(void)
{
	/* Sound Enable ? */
	if (!soundcard) return;

	/* Sound updated ? */
	if (mixer_count!=mixer_count_ok) return;

	/* Sound updated ! */
	mixer_count++;
	mixer_count=mixer_count & 0xff;
}


void playsample(int channel,signed char *data,int len,int freq,int volume,int loop, int pan, int bits)
{
	if (!soundcard || channel >= NUMVOICES) return;

	lpWave[channel].active=0;

        if (volume < 0) {
                volume = 0;
        } else if (volume > 0) {
                if (volume > 100) volume = volume * 25 / 255;
                volume = (volume*64) / 100;
                /* if (pan != OSD_PAN_CENTER) volume/=2; */
                if (soundcard==1) volume+=20;	/* Sound on */
                if (soundcard>=3) volume+=10;	/* Accurate sound */
                if (volume>64) volume=64;
        }

        if (freq < 0)
                freq = 0;

#if SOUND_USESAMPLE_PATCH
        if (len > 0) {
		lpWave[channel].lpData = data;
		lpWave[channel].len=len;
	}
	else {
		lpWave[channel].len=0;
	}
#else
        if (len > 0) {
                if (len>MAX_SAMPLE_NUMBER) len=MAX_SAMPLE_NUMBER; /* Maximum number of samples */
                if (bits==8) {
			if (soundcard < 3)	/* For non-accurate sound */
			{
				asm_memcpy(lpWave[channel].lpData, data, len);
			}
			else
			{
				int i;
				signed char *lpdata=lpWave[channel].lpData;

				for (i=0;i<len-4;i+=4) {                        
					*(int *)lpdata=*(int *)data;	/* copy 4x bytes at a time */
					lpdata+=4;
					data+=4;
				}
				for (;i<len;i++)
					*lpdata++= *data++;/* copy remaining byte(s) */
			}
			lpWave[channel].len=len;

                } else {
			int i;
			signed char *lpdata=lpWave[channel].lpData;
			for (i=0;i<len;i++) {
				data++; /* ignore low 8 bits */
				*lpdata++= *data++;
			}
			lpWave[channel].len=len>>1;
		}
	}
	else {
		len = 0;
		lpWave[channel].len=0;
	}
#endif

	lpWave[channel].volume=volume;
	lpWave[channel].freq=freq;
	lpWave[channel].loop=loop;

        if ((freq>0) && (len>0))
		lpWave[channel].active=1;
}


void osd_adjust_sample(int channel,int freq,int volume)
{
	
	if (!soundcard || channel >= NUMVOICES) return;

	if (freq != -1)
		lpWave[channel].freq=freq;
	if (volume != -1) {
		if (volume>0) {
			if (volume > 100) volume = volume / 10;
			volume = (volume<<6) / 100;
			if (volume>0) volume+=20;
			if (volume>64) volume=64;
		}
		lpWave[channel].volume = volume;
	}
}


void osd_stop_sample(int channel)
{
	if (!soundcard || channel >= NUMVOICES) return;
	lpWave[channel].active = 0;
}


void osd_restart_sample(int channel)
{
	if (!soundcard || channel >= NUMVOICES) return;
	lpWave[channel].active = 1;
}


int osd_get_sample_status(int channel)
{
	if (!soundcard || channel >= NUMVOICES) return -1;
	return !(lpWave[channel].active);
}


void osd_sound_enable(int enable_it)
{ 	
	sound_enable = enable_it;
}
